/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.perk;

import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.perk.PerkType;
import dev.toma.gunsrpg.common.perk.PerkValueSpec;
import dev.toma.gunsrpg.util.SkillUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class Perk {
    private ResourceLocation id;
    private final IAttributeId attributeId;
    private final float scaling;
    private final PerkValueSpec boundSpec;
    private final boolean invertCalculation;
    private ITextComponent displayName;

    public Perk(IAttributeId attributeId, float scaling, PerkValueSpec boundSpec, boolean invertCalculation) {
        this.attributeId = attributeId;
        this.scaling = scaling;
        this.boundSpec = boundSpec;
        this.invertCalculation = invertCalculation;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
        this.displayName = new TranslationTextComponent("perk." + SkillUtil.Localizations.convertToLocalizationKey(id));
    }

    public ResourceLocation getPerkId() {
        return this.id;
    }

    public IAttributeId getAttributeId() {
        return this.attributeId;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public double getModifier(int level, PerkType type) {
        float scale = this.getScaling();
        float bound = this.getBounds(type);
        double value = (float)level * scale;
        return value < 0.0 ? Math.max(value, (double)(-bound)) : Math.min(value, (double)bound);
    }

    public float getScaling() {
        return this.scaling;
    }

    public float getBounds(PerkType type) {
        return type.getValue(this.boundSpec);
    }

    public boolean shouldInvertCalculation() {
        return this.invertCalculation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Perk perk = (Perk)o;
        return this.attributeId.equals(perk.attributeId);
    }

    public int hashCode() {
        return this.attributeId.hashCode();
    }

    public String toString() {
        return "Perk{id=" + this.id + '}';
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        buffer.func_192572_a(this.attributeId.getId());
        buffer.writeFloat(this.scaling);
        this.boundSpec.encode(buffer);
        buffer.writeBoolean(this.invertCalculation);
    }

    public static Perk decode(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation attrId = buffer.func_192575_l();
        float scaling = buffer.readFloat();
        PerkValueSpec spec = PerkValueSpec.decode(buffer);
        boolean invertCalculation = buffer.readBoolean();
        IAttributeId attribute = Attribs.find(attrId);
        Perk perk = new Perk(attribute, scaling, spec, invertCalculation);
        perk.setId(id);
        return perk;
    }
}

